define([
    'underscore',
    'backbone',
    'App',
    'modules/notifications/models/notifications-collection',
],
function (_, Backbone, app, Notifications) {
    'use strict';

    return {
        fetchCollection: function(urlParams) {
            var options;
            if (urlParams) {
                options = {url: app.resources.get('notifications').formatHref(urlParams)};
            }
            return this.notifications.fetch(options);
        },
        notifications: new (Notifications.extend({
            fetch: function (options) {
                if (_.isUndefined(this.isReady)) {
                    if (!_.isUndefined(options) && _.isUndefined(this._lastFetchOptions)) {
                        this._lastFetchOptions = options;
                    }
                    this.isReady = Backbone.Collection.prototype.fetch.call(this, this._lastFetchOptions);
                }

                return this.isReady;
            },
        }))(),
    };
});
